<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS How to Run";
$page_h1 = "Overview of Running a Test Case";
include "ft_ss_head.php";
?>
<p>
    <p>
  <h2>Running the Test Cases:</h2>
	Now, you are ready to run the selected test cases. The work flow is as follows:</li>
	<ol>
	<li>Select the <b>Run a Test Case</b> task from the task menu. This takes you to the
	<b>Test Case Selection Page</b></li>
	<li>From the <b>Test Case Selection Page</b> select the case you want to run and you will
	see two items for configuring the case:
	a collection of search tool settings and a set of search strings.</li>
	<li>You will also see a list of check boxes for recording hits reported in Active Files,
	Deleted Files and Unallocated Space.
	<li>Mark the check boxes corresponding to hits reported by the tool.</li>
	<li>There is a comment & observations box to record any observations
	for inclusion in the test report.
	<li>Use the <b>Save Results</b> button to record results.</li>
	</ol>
	  <p>Repeat the basic work flow for other search engines and test data sets.
	  <ol>
      <li>Run each selected test case and record results to the FT-LOGS flash drive.</li>
	  <li>If you are testing more than one search engine, use the task menu on the left
	  to set the next search engine to test and run the test cases again with the
	  new search engine.
	  <li>If you are using both test images, run everything again with the second
	  test image.
      <li>Select the <b>Generate a Test Report</b> task link to create a
	  draft test report skeleton on the log flash drive.<br>
      </li>
	  <li>Finalize the test report and submit (optional) to CFTT and share the results.
    </ol>
<br>
<?php
/*
*/
include "ft_ss_home_links.php";
?>
<br>
<form method="POST"
action="/stringsearch/ft_ss_home.php">
<input value="Press the button" type="submit"> </form>
<?php
	include "ft_ss_tail.php";
?>

